standardFont = "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec";
standardFont2 = "HiddenObject/UI/Font/TAMLKamban.mvec";

BlackColor = Color(0,0,0,255);
BlueColor = Color(77,115,178,255);
DarkBlueColor = Color(40,60,120,255);
WhiteColor = Color(173,193,161,255);
MenuButtonFontColor = Color(173,193,161,255);
WhiteColor1 = Color(255,255,255,255);
SimonTextColor = Color(131,167,184,255);
ButtonTextColor =  Color(131, 167, 184, 255);
StandardButtonTextColor =  Color(131, 167, 184, 255);
StandardDialogBodyTextColor = Color(204, 198, 183, 255);



StandardButtonGraphics = {
	"HiddenObject/UI/Button/buttonup",
	"HiddenObject/UI/Button/buttondown",
	"HiddenObject/UI/Button/buttonrollover"
};

LongButtonGraphics = {
	"HiddenObject/UI/Button/long_button_up.png",
	"HiddenObject/UI/Button/long_button_down.png",
	"HiddenObject/UI/Button/long_button_over.png"
};

CheckboxButtonGraphics = {
	"HiddenObject/UI/Button/checkup",
	"HiddenObject/UI/Button/checkdown",
	"HiddenObject/UI/Button/checkover",
	"HiddenObject/UI/Button/checkdownover"
};

ButtonGraphics_Hint = {
	"HiddenObject/UI/button/hintnormal",
	"HiddenObject/UI/button/hintmousedown",
	"HiddenObject/UI/button/hintmouseover"
};


ButtonGraphics_Menu = {
	"HiddenObject/UI/button/menunormal",
	"HiddenObject/UI/button/menumousedown",
	"HiddenObject/UI/button/menumouseover"
};

ButtonGraphics_SimonMenu = {
	"Simon/UI/simonmenunormal",
	"Simon/UI/simonmenumousedown",
	"Simon/UI/simonmenumouseover"
};

ButtonGraphics_Skip = {
	"Simon/UI/skipnormal",
	"Simon/UI/skipmousedown",
	"Simon/UI/skipmouseover"
};

StandardButtonFont = {
  standardFont,
  24,
  StandardButtonTextColor 
};

StandardHeaderFont = {
  standardFont,
  32,
  StandardButtonTextColor 
};


ButtonStyle_Skip = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = ButtonGraphics_Skip,
};


ButtonStyle_Hint = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = ButtonGraphics_Hint,
};


ButtonStyle_Menu = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = ButtonGraphics_Menu,
};


LeftCurveGraphics = {
	"HiddenObject/UI/Button/leftcurvenormal",
	"HiddenObject/UI/Button/leftcurvedown",
	"HiddenObject/UI/Button/leftcurveover"
};


LeftCurveStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = LeftCurveGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};




RightCurveGraphics = {
	"HiddenObject/UI/Button/Rightcurvenormal",
	"HiddenObject/UI/Button/Rightcurvedown",
	"HiddenObject/UI/Button/Rightcurveover"
};


RightCurveStyle = {
	parent = DefaultStyle,
	rolloversound = kDefaultButtonOverSound,	
	font = StandardButtonFont,
	type= kPush,
	graphics = RightCurveGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};


MenuButtonFont = {
  standardFont,
  22,
  MenuButtonFontColor
};

DialogTitleFont = {
  standardFont,
  20,
  WhiteColor
};

DialogBodyFont = {
  standardFont,
  18,
  WhiteColor
};

DefaultStyle = {
	font=DialogBodyFont
};

DialogTitleText = {
	parent=DefaultStyle,
	font = DialogTitleFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=30
};

DialogBodyText = {
	parent=DefaultStyle,
	font = DialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};

SliderStyle =
{
	parent=DefaultStyle,
	railtop = "HiddenObject/UI/slider/sliderrailtop",
	railmid = "HiddenObject/UI/slider/sliderrailmid",
	railbot = "HiddenObject/UI/slider/sliderrailbot",
	sliderimage = "HiddenObject/UI/slider/sliderknob",
	sliderrollimage = "HiddenObject/UI/slider/sliderknobover",

	yoffset = -1, -- scoot the slider down by one pixel to center it.
};

kDefaultButtonSound="HiddenObject/Audio/sfx/buttonclick.ogg";
kDefaultButtonOverSound="HiddenObject/Audio/sfx/buttonrollover.ogg";

MenuButtonStyle = {
	parent = DefaultStyle,
	font = MenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	graphics = {},
	w=169, h=40
};

ButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont2,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = StandardButtonGraphics,
};

LongButtonStyle = {
	parent = ButtonStyle,
	graphics = LongButtonGraphics
};

CheckboxButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	type = kToggle,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	graphics = CheckboxButtonGraphics,
};

StandardHeaderFont = {
  standardFont,
  32,
  Color(131, 167, 184, 255)
};


SetDefaultStyle(DefaultStyle);

-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function Button( button )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			-- Get the label
			local label = GetTag(button,"label");

			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button,
				SelectLayer( kAllLayers )
			);
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button,
				FitToChildren()
			);

			table.insert(button,
				AppendStyle{ font=button.font; flags=button.flags; }
			);

			table.insert(button,
				Text
				{
					label=label,
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags
				}
			)
		end

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='Button';
		DoWindow( button )
	end
end

-- Create several bits of text that combine to make a blended shadow
function ColorShadowText( x,y,size, label, color )

	return Group(
		{
		-- Add these traits to the current style
			AppendStyle{ x=x, y=y, w=kMax, h=kMax, label=label },
			AppendStyle{ font = { standardFont, size, Color(0,0,0,40)} },
			Text{ y=y+4 },
			AppendStyle{ font = { standardFont, size, Color(0,0,0,255)} },
			Text{ y=y+2 },
			AppendStyle{ font = { standardFont, size, color } } ,
			Text{},
		}
	)
end

kMenuButtonFontSize = 22;

function MenuButtonLabel( label, color, colorHighlight )

	if not color then
		color =Color(192,207,255,255);	-- the default colors
		colorHighlight=Color(255,255,255,255)
	end

	return Group{
		
		SelectLayer(0),
		ColorShadowText(5,8,kMenuButtonFontSize, label, color ),
		SelectLayer(1),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight ),
		SelectLayer(2),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight )
	}

end

-- Create a more limited-use button type here; the label is defined inline
-- with MenuButtonLabel above
function MenuButton( button )
	return function()
		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='Button';
		DoWindow( button )
	end
end

kIllegalNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-_";